@if(!game_engine()->user()->current_organization_id)
    {{__('You must choose an Organization in order to see your teams')}}
@else

        <?php

        $query = game_engine()->user()->can('viewAny', \DefStudio\GameEngine\Models\Team::class)
            ? game_engine()->user()->current_organization->teams()
            : game_engine()->user()->current_teams();

        $teams = $query
            ->with('organization')
            ->withCount(['players', 'masters'])
            ->get();
        ?>

    @if($teams->isNotEmpty())
        <x-container {{$attributes}}>
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4  gap-4">
                @foreach($teams as $team)
                    <x-game-engine::teams.card :team="$team"/>
                @endforeach

                @can('create', \DefStudio\GameEngine\Models\Team::class)
                    <x-game-engine::teams.card/>
                @endcan
            </div>
        </x-container>
    @endif

@endif
