<?php
/** @var \DefStudio\GameEngine\Models\Run $model */
?>


@if($model->completed_at)
    <div>
        {{__('Finished')}}
    </div>
    <div>
        {{$model->completed_at->format('d/m/y H:i')}}
    </div>
@elseif($model->started_at === null)
    <div>
        {{__('Not Started')}}
    </div>
@elseif($pause_info = $model->is_paused())
    <div>
        {{$pause_info->activity_title}}
    </div>
    <div>
        {{__('Paused :time', ['time' => $pause_info->time->locale(game_engine()->user()->locale)->diffForHumans()])}}
    </div>
@elseif($model->updated_at->toImmutable()->addSeconds(config('game-engine.runs.timers.max_tick_duration_seconds', 0))->isFuture())
    <div>
        {{\DefStudio\GameEngine\Actions\Runs\CurrentActivityTitle::run($model)}}
    </div>
    <div>
        {{__('Last Activity :time', ['time' => $model->updated_at->locale(game_engine()->user()->locale)->diffForHumans()])}}
    </div>
@else
    <div>
        {{__('Abandoned')}}
    </div>
    <div>
        {{$model->updated_at->locale(game_engine()->user()->locale)->diffForHumans()}}
    </div>
@endif

