<?php

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Models\User;
use DefStudio\GameEngine\Models\Team;

/** @var User $model */
/** @var Team $team */
?>

<div class="flex">
    @can('update', $model)
        <x-game-engine::teams.users-table.actions.edit :user="$model"/>
    @endcan

    <x-game-engine::impersonate :user="$model"/>

    @if($model->id !== game_engine()->user()->id)
        @can('subscribe', [$team, $model])
           <x-game-engine::teams.users-table.actions.subscribe :team="$team" :user="$model"/>
        @endcan
    @endif
</div>
