<?php

namespace DefStudio\GameEngine\Actions\Runs;

use DefStudio\Actions\Action;
use DefStudio\GameEngine\Models\Run;

/**
 * @method static string run(Run $run)
 */
class CurrentActivityTitle extends Action
{
    public function handle(Run $run): string
    {
        return $this->get_current_task_title($run)
            ?? $this->get_current_mission_title($run)
            ?? $this->get_current_map_title($run)
            ?? $this->get_current_story_title($run)
            ?? __('Not Started');
    }

    protected function get_current_task_title(Run $run): ?string
    {
        return $run->playable_story()
            ->current_playable_map()
            ?->current_playable_mission()
            ?->current_playable_task()
            ?->title;
    }

    protected function get_current_mission_title(Run $run): ?string
    {
        return $run->playable_story()
            ->current_playable_map()
            ?->current_playable_mission()
            ?->title;
    }

    protected function get_current_map_title(Run $run): ?string
    {
        return $run->playable_story()
            ->current_playable_map()
            ?->title;
    }

    protected function get_current_story_title(Run $run): ?string
    {
        if ($run->started_at === null) {
            return __('Not Started');
        }

        if ($run->completed_at !== null) {
            return __('Ended');
        }

        return __('Just Started');
    }
}
