<?php

namespace DefStudio\GameEngine\Actions\Stories;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Events\Stories\StorySaved;
use DefStudio\GameEngine\Events\Stories\StoryCreated;
use DefStudio\GameEngine\Events\Stories\StoryUpdated;

/**
 * @method static Story run(Story $story, bool $global = false)
 */
class SaveStory extends Action
{
    public function handle(Story $story, bool $global = false): Story
    {
        Gate::authorize('save', $story);

        if ($global) {
            $story->organization_id = null;
        } else {
            $story->organization_id ??= game_engine()->user()->current_organization_id;
        }

        $story->save();

        StoryCreated::dispatchIf($story->wasRecentlyCreated, $story);
        StoryUpdated::dispatchIf(!$story->wasRecentlyCreated, $story);
        StorySaved::dispatch($story);

        return $story;
    }
}
