<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Enums;

enum Permission: string
{
    case view_users = 'view.users';
    case create_users = 'create.users';
    case edit_users = 'edit.users';
    case delete_users = 'delete.users';
    case impersonate_users = 'impersonate.users';

    case view_all_teams = 'view.teams.all';
    case view_teams = 'view.teams';
    case subscribe_to_teams = 'subscribe.to.teams';
    case create_teams = 'create.teams';
    case edit_teams = 'edit.teams';
    case delete_teams = 'delete.teams';

    case view_organizations = 'view.organizations';
    case create_organizations = 'create.organizations';
    case edit_organizations = 'edit.organizations';
    case delete_organizations = 'delete.organizations';

    case view_stories = 'view_stories';
    case create_stories = 'create_stories';
    case edit_stories = 'edit_stories';
    case delete_stories = 'delete_stories';

    case manage_awards = 'manage_awards';

    case view_runs = 'view_runs';
    case delete_runs = 'delete_runs';
    case update_runs = 'update_runs';
    case create_runs = 'create_runs';
    case edit_runs = 'edit_runs';
    case debug_runs = 'debug_runs';

    public function for_role(?Role $role): string
    {
        return $this->value.'.'.($role?->value ?? 'guest');
    }
}
