<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are prohibited without the prior written permission of DEF STUDIO S.R.L. This software is provided "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.
 */

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Illuminate\Contracts\View\View;
use DefStudio\GameEngine\Enums\Feature;
use DefStudio\GameEngine\Models\Organization;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

use function game_engine;

class TeamsController
{
    use AuthorizesRequests;

    public function index(): View
    {
        Feature::teams->enforce();

        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);

        $this->authorize('viewAny', game_engine()->teamClass());

        return view('game-engine::admin.teams.index', ['organization' => $organization]);
    }

    public function create(): View
    {
        Feature::teams->enforce();

        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);

        $this->authorize('create', game_engine()->teamClass());

        return view('game-engine::admin.teams.edit', ['organization' => $organization]);
    }

    public function edit(int $team): View
    {
        Feature::teams->enforce();

        /** @var Organization $organization */
        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);
        $team = $organization->teams()->findOrFail($team);

        abort_unless(game_engine()->user()->canAny(['view', 'update'], $team), Response::HTTP_FORBIDDEN);

        return view('game-engine::admin.teams.edit', ['organization' => $organization, 'team' => $team]);
    }

    public function register(int $organization)
    {
        return view('game-engine::admin.teams.register', ['organization' => game_engine()->organizationQuery()->findOrFail($organization)]);
    }
}
