<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are prohibited without the prior written permission of DEF STUDIO S.R.L. This software is provided "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.
 */ /*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */ /** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Livewire\Users;

use DefStudio\GameEngine\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\Relation;
use DefStudio\GameEngine\Http\Livewire\Stories\SubscriptionsTable;

/**
 * @property User $subscriber
 */
class StoriesTable extends SubscriptionsTable
{
    protected function query(): Builder|Relation
    {
        return game_engine()->storyQuery()
            ->whereIn('organization_id', $this->subscriber->organizations()->pluck('id'))
            ->orWhereNull('organization_id')
            ->with('users', 'teams');
    }

    protected function active_filter(Relation|Builder $query, string $display): void
    {
        match ($display) {
            'subscribed' => $query->whereHas('users', fn(Builder|Relation $subquery) => $subquery->where('users.id', $this->subscriber->id)),
            'available' => $query->whereHas('users', fn(Builder|Relation $subquery) => $subquery->where('users.id', $this->subscriber->id), '=', 0),
        };
    }
}
