@php
    use DefStudio\GameEngine\Http\Livewire\Awards\AwardList;
    use DefStudio\GameEngine\Enums\MediaCollection;
    use DefStudio\GameEngine\Enums\MediaConversion;

    /** @var AwardList $this */
@endphp
<div class=" space-y-6">
    <div class="flex flex-col space-y-4" wire:sortable="update_order">
        @foreach(\DefStudio\GameEngine\Actions\Awards\GetAwardsForScope::run($this->scope)->except($this->awards->pluck('id')->toArray())->load('scope') as $award)
            <x-game-engine::elements.marked-box wire:key="award-{{$award->id}}"
                                                :image="$award->getFirstMedia(MediaCollection::icon)"
                                                large
            >
                <div class="my-auto">
                    {{$award->name}}
                </div>
                <div class="ml-auto flex">
                    @if($award->scope)
                        <div class="my-auto text-gray-600">
                            {{$award->scope->award_scope_label()}}
                        </div>
                    @endif
                    <div class="ml-4 w-64">

                    </div>
                </div>
            </x-game-engine::elements.marked-box>
        @endforeach
        @foreach($this->awards as $award)
            <x-game-engine::elements.marked-box class="cursor-move"
                                                wire:sortable.handle
                                                wire:sortable.item="{{$award->id}}"
                                                wire:key="award-{{$award->id}}"
                                                :image="$award->getFirstMedia(MediaCollection::icon)"
                                                large
            >
                <div class="my-auto">
                    {{$award->name}}
                </div>
                <div class="ml-auto flex">
                    @if($award->scope)
                        <div class="my-auto text-gray-600">
                            {{$award->scope->award_scope_label()}}
                        </div>
                    @endif
                    <div class="ml-4 w-64 flex flex-row-reverse">
                        @can('delete', $award)
                            <x-confirm-action class="ml-3" title="Warning"
                                              :content="__('Do you really want to delete this award?')"
                                              :requires-password="true"
                                              wire:then="delete({{$award->id}})"
                            >
                                <x-button icon="trash" color="secondary" size="sm"/>
                            </x-confirm-action>
                        @endcan
                        @can('update', $award)
                            <x-button icon="pencil" color="secondary" size="sm"
                                      wire:click="$emit('openModal', 'game-engine.admin.awards.edit', {{json_encode(['isModal' => true, 'award_id' => $award->id])}})"
                            />
                        @endcan
                    </div>
                </div>

            </x-game-engine::elements.marked-box>
        @endforeach
    </div>

    <div class="flex">
        @can('create', \DefStudio\GameEngine\Models\Award::class)
            <x-button class="ml-auto" onclick="Livewire.emit('openModal', 'game-engine.admin.awards.edit', {{json_encode(['isModal' => true, 'parent_id' => $parent?->id, 'scope_type' => $scope?->getMorphClass(), 'scope_id' => $scope?->id])}})">
                @if($parent)
                    {{__("Create Child Award")}}
                @elseif($scope)
                    {{__("Create Award")}}
                @else
                    {{__("Create Global Award")}}
                @endif
            </x-button>
        @endcan
    </div>
</div>
