<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Exceptions;

use Exception;
use DefStudio\GameEngine\Models\User;

class StoryException extends Exception
{
    public static function already_subscribed(): StoryException
    {
        return new self('Cannot subscribe a subject twice to a story');
    }

    public static function subscription_failure(): StoryException
    {
        return new self('Subject is not subscribed to story');
    }

    public static function organization_membership_failure(): StoryException
    {
        return new self('Story does not belongs to current organization');
    }

    public static function already_played(User $user): StoryException
    {
        return new self("User [#$user->id $user->email] cannot replay story when Feature [allow_replay] is disabled");
    }
}
