@php
    use DefStudio\GameEngine\Http\Livewire\Runs\Runner;
    use DefStudio\GameEngine\Enums\MediaCollection;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMission;
    use DefStudio\GameEngine\Enums\StorytellingType;

    /** @var Runner $this */
@endphp

@if($this->current_map_index() >= 0)
    <x-game-engine::runs.map.box class="flex justify-center items-center">
        <!--suppress JSUnresolvedReference -->
        <script>

            if (window.Alpine === undefined) {
                document.addEventListener('alpine:init', init_alpine_map);
            } else {
                init_alpine_map();
            }

            function init_alpine_map() {
                Alpine.data('map', () => ({
                    missions: [],
                    current_mission_index: 0,
                    size: {w: 0, h: 0, zoom: 1, margins: {top: 0, left: 0}},
                    ready: false,
                    deadline: null,
                    remaining_time: '',

                    init() {
                        this.$nextTick(() => {
                            console.debug('map init');

                            this.size.w = this.$refs.background.naturalWidth;
                            this.size.h = this.$refs.background.naturalHeight;
                            this.update_zoom();
                            this.update_missions();
                            this.set_timer();
                        });

                        this.$wire.on('mission:activated', () => {
                            this.update_missions()
                        });
                    },
                    set_timer() {
                        console.log('setting up timer');

                        this.$wire.call('get_map_deadline').then(deadline => {
                            if (deadline === null) {
                                return;
                            }

                            this.deadline = new Date(deadline)

                            console.debug('deadline', deadline);

                            setTimeout(() => this.handle_timeout(), this.deadline - (new Date()));
                            setInterval(() => this.update_countdown(), 1000);
                        });
                    },
                    handle_timeout() {
                        console.debug('time has runned out!');
                        this.$wire.call('force_map_timeout');
                    },
                    update_countdown(){
                        if(this.deadline === undefined){
                            this.remaining_time = 'no timer';
                            return;
                        }

                        const remaining_time = this.deadline.getTime() - (new Date()).getTime();

                        const minutes = Math.floor((remaining_time % (1000 * 60 * 60)) / (1000 * 60));
                        const seconds = Math.floor((remaining_time % (1000 * 60)) / 1000);

                        this.remaining_time = `${minutes}m ${seconds}s`;
                    },
                    update_missions() {
                        this.$wire.call('current_mission_index').then(index => this.current_mission_index = index);

                        this.$wire.call('get_missions').then(missions => {
                            this.missions = missions;
                            this.ready = true;
                        });
                    },
                    update_zoom() {
                        const screen_w = document.documentElement.clientWidth;
                        const screen_h = document.documentElement.clientHeight;

                        if (screen_w >= this.size.w && screen_h >= this.size.h) {
                            this.size.zoom = 1;
                            return;
                        }

                        const zoom_w = screen_w / this.size.w;
                        const zoom_h = screen_h / this.size.h;

                        this.size.zoom = Math.min(zoom_w, zoom_h);
                    },
                    is_active(mission_index) {
                        if (this.missions[+mission_index].always_active) {
                            return true;
                        }

                        return +this.current_mission_index === +mission_index;
                    },
                    open_mission(mission_index) {
                        if (!this.is_active(mission_index)) {
                            return;
                        }

                        this.$wire.call('start_mission', mission_index);
                    }
                }));
            }

        </script>


        <div x-data="map" class="relative min-w-fit" :style="{zoom: size.zoom, width: size.w+'px', height: size.h+'px'}" @resize.window="update_zoom" x-show="ready" x-cloak>
            @if(game_engine()->role(\DefStudio\GameEngine\Enums\Role::super_admin))
                <div class="fixed top-5 left-5">
                    <span x-text="remaining_time"/>
                </div>
            @endif

            <img src="{{$this->map->getFirstMediaUrl(MediaCollection::background)}}" x-ref="background">


            <template x-for="(mission, mission_index) in missions" :key="mission.id">
                <img class="absolute"
                     :class="{'cursor-pointer': is_active(mission_index)}"
                     :style="{top: mission.pos_y+'px', left: mission.pos_x+'px'}"
                     :src="mission.placeholder_image"
                     x-show="mission.visible"
                     @click="open_mission(mission_index)"
                >
            </template>
        </div>


    </x-game-engine::runs.map.box>
@endif
