<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Listeners\Organizations;

use DefStudio\GameEngine\Models\Story;
use DefStudio\GameEngine\Actions\Stories\DeleteStory;
use DefStudio\GameEngine\Events\Organizations\DeletingOrganization;

class DeletingOrganizationListener
{
    public function handle(DeletingOrganization $event): void
    {
        $event->organization->loadMissing('stories.maps.missions.tasks');
        $event->organization->stories->each(fn(Story $story) => DeleteStory::run($story));
    }
}
